 aR  w 1 m^9      h	 oP    nSystem-wide
$NOLIST

NAME KB_Int

;	KEYBOARD INTERRUPT ROUTINE
;  
;  The upper byte of the char is defined as follows:
;
;	Bit 0
;	Bit 1
;	Bit 2
;	Bit 3 - FKey Bit (indicates CODE-# key came from FKey not CODE-#)
;	Bit 4 - Repeat Bit
;	Bit 5 - Shift Bit
;	Bit 6 - CODE bit
;	Bit 7 - Ctrl Bit



PUBLIC KB_Int
PUBLIC InitTheKeyboard
PUBLIC GetKeyFromDOS

PUBLIC key_Flags
PUBLIC shiftBits


CGROUP GROUP CODE
DGROUP GROUP DATA


EXTRN  CpSignal: FAR
EXTRN  CpEnableInterrupt: FAR
EXTRN  CpSetInterrupt: FAR


;	*******
;	EQUATES
;	*******

; KEYFLAG MASKS

ctl            EQU 80H
CODEBIT        EQU 40H
SHIFT          EQU 20H
Repeat_bit     EQU 10H	; status repeat bit
FKEY           EQU 08H	; Bit 3 in upper byte of char


CAPS           EQU 20H
NumLockState   EQU 20H

; OTHER MASKS

CTL_MASK       EQU 9FH	; MASK FOR CTL CHAR
BREAK          EQU 80H

; KEYBOARD PORTS

KB_DATA        EQU 60H	; KEYBAORD SCAN CODE PORT
KB_STS         EQU 64H	; KEYBOARD STATUS PORT
KB_CTL         EQU 64H	; KEYBOARD CONTROL PORT


; SHIFT KEY SCAN CODES

LS_KEY         EQU 02AH	; LEFT SHIFT
RS_KEY         EQU 036H	; RIGHT SHIFT
CAPS_KEY       EQU 03AH	; CAPS LOCK
NUM_LOCK_KEY   EQU 045H	; NUM LOCK KEY
leftShiftMask  EQU 1	; mask for shiftbits
rightShiftMask EQU 2	

; CODE KEY SCAN CODE

CODE_KEY       EQU 038H	; PC ALT KEY
CTL_KEY        EQU 01DH	; CONTROL KEY

; Misc Equates

signalNormal   EQU 1
dontReschedule EQU 80h
NullByte       EQU 0FFh
intKeyboard    EQU 2
NULLWORD       EQU 0FFFFh
Hornet         EQU 1
IBMPC          EQU 2
IBMAT          EQU 3
$EJECT


DATA SEGMENT PUBLIC 'DATA'

EXTRN keyboardStatusKey: WORD
EXTRN keyHandlerOff: WORD

EXTRN keySema: WORD	; sema to communicate to key process
EXTRN gridMachine: BYTE	; target system (GRiD/Non-GRiD)
EXTRN systemType: BYTE	; target system (PC/AT)


key_Mask	         DB 1 DUP (?)	; High byte of key char
key_Flags         DB 0	; KEYBOARD STATUS
oldKeyRoutineOff  DW 1 DUP (?)	; old int service routine
oldKeyRoutineSeg  DW 1 DUP (?)
error             DW 1 DUP (?)	; sema error
Last_Char         DB 1 DUP (?)	; Last character processed
NextToLastChar    DB 1 DUP (?)	; Next to last char processed
Last_Scan_Code    DB 1 DUP (?)	; Last scan code
ShiftBits         DB 0	; right/left shift status

DATA ENDS



CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP, DS:DGROUP

	EXTRN DataFrame: WORD
$EJECT

;------------------------------------------------------------------------------
; Enable AT-type keyboard
;
;	Input:  None
;	Output: Zero flag set if OK, else error
;	Carry flag = 0
;------------------------------------------------------------------------------

;EnableKB PROC NEAR
;	CALL	Vwfibe_I
;	MOV	AL, 0AEH
;	OUT	KB_CTL, AL
;	RET
;EnableKB ENDP

;------------------------------------------------------------------------------
; Disable AT-type keyboard
;
;	Input:  None
;	Output: CX = ?
;	  AL = Keyboard status
;	  Ints re-enabled, Zero flag set if OK, else error
;	  Carry flag = 0
;------------------------------------------------------------------------------

DisableKB PROC NEAR
	CALL	Vwfibe_I
	JNZ	DsbK1

	CALL	Vwfibe
	JNZ	DsbK1

	MOV	AL, 0ADH
	OUT	KB_CTL, AL
;	STI
	CALL	Vwfibe_I

DsbK1:
	RET
DisableKB ENDP

; Vwfibe = (V) Wait For 8042 Input Buffer Empty
;------------------------------------------------------------------------------
; Wait for 8042 input buffer empty
;	Input:  CX = wait count
;	Output: Ints disabled, Z clear if error, else set
;------------------------------------------------------------------------------

Vwfibe PROC NEAR
	CLI

Vwfibe_I PROC NEAR
	XOR	CX, CX	; Test for keyboard buffer empty up to 64K times

Vwfibe0:
	IN	AL, KB_STS
	TEST	AL, 2
	LOOPNZ Vwfibe0

	RET
Vwfibe_I ENDP
Vwfibe ENDP
$EJECT

; KB_Int: PROCEDURE INTERRUPT;
; This is the keyboard interrupt service routine.
; It is just a shell around the default one provided by the BIOS.
; It just keeps track of the key modifiers.
;

KB_INT PROC
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES

	MOV	AX, DGROUP
	MOV	DS, AX
	MOV	AX, CS
	MOV	ES, AX	; setup DS and ES


; This test is here to check for cases when InteGRiD and the BIOS
; are out of sync keyboard-wise

; This is commented out now, but may be useful for debugging in the future

;	MOV	AH, 2
;	INT	16H	; Return key flags in AL

;	MOV	DL, AL
;	MOV	CL, 5
;	SHL	DL, CL
;	AND	DL, 80H	; Move BIOS Ctl flag to InteGRiD position
;	MOV	BL, DL	; Save it

;	MOV	DL, AL
;	MOV	CL, 3
;	SHL	DL, CL
;	AND	DL, 40H	; Move BIOS Alt flag to InteGRiD position
;	OR	BL, DL	; Add it in

;	MOV	DL, AL
;	MOV	CL, 4
;	SHL	DL, CL
;	AND	DL, 20H	; Move BIOS Left shift flag to InteGRiD position
;	OR	BL, DL	; Add it in

;	MOV	DL, AL
;	MOV	CL, 5
;	SHL	DL, CL
;	AND	DL, 20H	; Move BIOS Rt shift flag to InteGRiD position
;	OR	BL, DL	; Add it in

;	CMP	BL, key_Flags
;	JE	No_Problem

;	MOV	AX, 0E07H	; Do a beep
;	INT	10H

;No_Problem:

	CMP systemType, IBMAT	; If not an IBM-PC/AT
	JNE KbGetChar	; then don't worry

	CALL	DisableKB	; Have kbd proc wait for key to be processed

KbGetChar:
	IN	AL, KB_DATA	; Get Char
	MOV	AH, AL	; Save In AH

; TEST FOR OVERRUN SCAN CODE

	CMP	AL, 0FFH	; Is This Overrun
	JNZ	TESTSHIFT 	; Not Overrun, Test Shift
	JMP	EXIT_KEYBOARD	; Done

; TEST FOR SHIFT KEYS

TESTSHIFT:
	MOV	CL, shiftBits
	AND	AL, 07FH	; Turn Off Break Bit
	CMP	AL, LS_Key
	JNE	TryRS_Key
	MOV	BL, LeftShiftMask
	JMP	SHORT SetShiftBits

TryRS_Key:
	CMP	AL, RS_Key
	JNE	TestCode
	MOV	BL, rightShiftMask

SetShiftBits:
	MOV	AL, AH
	TEST	AL, BREAK	; Test For Break Bit
	JNZ	ResetShift 	; Turn Off Shift bit
	OR	CL, BL	; Turn On shift bit
	JMP	SHORT FigureOutShiftStatus

ResetShift:
	NOT	BL
	AND	CL, BL

FigureOutShiftStatus:
	MOV	shiftBits, CL	; Store the shift bits
	TEST	CL, leftShiftMask + rightShiftMask
	JZ	SHIFT_OFF
	
; TURN ON SHIFT

SHIFT_ON:
	OR	key_Flags, SHIFT	; Turn On Bit
	JMP	REAL_KEYBOARD	; Done

; TURN OFF SHIFT

SHIFT_OFF:
	MOV	AL, SHIFT	; Mask In AH
	NOT	AL	; Invert
	AND	key_Flags, AL	; Turn Off Bit
	JMP	REAL_KEYBOARD	; Done

; TEST FOR CODE KEY

TESTCODE:
	CMP	AL, CODE_KEY	; Is It Code Key 
	JNE	TESTCTL	; No, Look For Control

; CODE KEY FOUND

CODE_FND:
	MOV	AL, AH	; Restore Scan Code
	TEST	AL, BREAK	; Test For Break Bit
	JNZ	CODE_OFF	; Turn Off Code
		
; TURN ON CODE KEY

	OR	key_Flags, CODEBIT	; Turn On Bit
	JMP	REAL_KEYBOARD	; Done

; TURN OFF CODE KEY

CODE_OFF:
	MOV	AL, CODEBIT	; Mask In AH
	NOT	AL	; Invert
	AND	key_Flags, AL	; Turn Off Bit
	JMP	REAL_KEYBOARD	; Done


; TEST FOR CONTROL KEY

TESTCTL:
	CMP	AL, CTL_KEY	; Is It Control Key 
	JNE	TESTCHAR	; No, Look For Chars			

; CONTROL KEY FOUND

	MOV	AL, AH	; Restore Scan Code
	TEST	AL, BREAK	; Test For Break Bit
	JNZ	CTL_OFF	; Turn Off Control Key

; TURN ON CONTROL KEY

	OR	key_Flags, CTL	; Turn On Bit
	JMP	REAL_KEYBOARD	; Done

; TURN OFF CONTROL KEY

Ctl_Off:
	MOV	AL, CTL	; Mask In AH
	NOT	AL	; Invert
	AND	key_Flags, AL	; Turn Off Bit
	JMP	REAL_KEYBOARD	; Done

TestChar:
	MOV	AL, AH	; Restore Full Scan Code
	TEST	AL, BREAK	; Test For Break Bit
	JZ	repeat_test	; no break found, go on
	MOV	Last_Char, NULLBYTE	; Invalidate Last_Chars
	MOV	NextToLastChar, NULLBYTE
	JMP	REAL_KEYBOARD	; Key Upstroke, No Char

; Test for repeat status

Repeat_Test:
	MOV	BH, key_Flags
	CMP	AL, Last_Char	; no upstroke, same char?
	JE	RepeatKey	; new char, not repeat
	CMP	AL, NextToLastChar	; no upstroke, same char?
	JNE	Not_Repeat	; new char, not repeat
RepeatKey:
	OR	BH, Repeat_bit	; repeated char, set bit

Not_Repeat:
	MOV	key_Mask, BH	; current character

Put_Char:
	MOV	BL, Last_Char	; set the next to last char
	MOV	NextToLastChar, BL
	MOV	Last_Char, AL	; record char before sending

Real_Keyboard:
	MOV	Last_Scan_Code, AH

	PUSHF
	CALL	DWORD PTR DS:OldKeyRoutineOff  ; call the regular int service routine.

; Signal the process if necessary

	MOV	AX, DS:keySema
	PUSH	AX	; sema
	MOV	AX, signalNormal       ; + dontReschedule <- For Ps2Model30 fix ???
	PUSH	AX
	XOR	AX, AX
	PUSH	AX	; note = 0
	PUSH	DS
	MOV	AX, OFFSET DGROUP:error
	PUSH	AX	; @error
	CALL	CpSignal


; RETURN FROM INTERRUPT

EXIT_KEYBOARD:
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX	; RESTORE STATE
	IRET		; RETURN FROM INTERRUPT
KB_INT ENDP
$EJECT

; 
;	InitTheKeyboard
;
; 1. Save the old keyboard int service routine
; 2. Set KB_Int

InitTheKeyboard PROC NEAR
	PUSH	DS
	MOV	DS, CS:DataFrame

	MOV	AX, intKeyboard
	PUSH	AX
	PUSH	CS
	MOV	AX, OFFSET KB_INT
	PUSH	AX
	CALL	CpSetInterrupt	; set KB_INT
	MOV	oldKeyRoutineOff, BX	; old int service routine
	MOV	oldKeyRoutineSeg, ES

	MOV	AX, intKeyboard
	PUSH	AX
	PUSH	AX	; mode is unused
	CALL	CpEnableInterrupt	; CALL CpEnableInterrupt(intKeyboard, mode)

	POP	DS
	RET
InitTheKeyboard ENDP

$EJECT

Table1:
; This table is for CODE and CODE-SHIFT processing of chars < scancode 32h.
	DB	0F1H,0F1H	;16 Q
	DB	0F7H,0F7H	;17 W
	DB	0E5H,0E5H	;18 E
	DB	0F2H,0F2H	;19 R
	DB	0F4H,0F4H	;20 T
	DB	0F9H,0F9H	;21 Y
	DB	0F5H,0F5H	;22 U
	DB	0E9H,0E9H	;23 I
	DB	0EFH,0EFH	;24 O
	DB	0F0H,0F0H	;25 P
	DB	-1,-1	;26 [
	DB	-1,-1	;27 ]
	DB	8DH,8CH	;28 CR
	DB	-1,-1	;29 CTL
	DB	0E1H,0E1H	;30 A
	DB	0F3H,0F3H	;31 S
	DB	0E4H,0E4H	;32 D
	DB	0E6H,0E6H	;33 F
	DB	0E7H,0E7H	;34 G
	DB	0E8H,0E8H	;35 H
	DB	0EAH,0EAH	;36 J
	DB	0EBH,0EBH	;37 K
	DB	0ECH,0ECH	;38 L
	DB	7EH,7CH	;39 ;
	DB	60H,5CH	;40 '
	DB	-1,-1	;41 `
	DB	-1,-1	;42 LEFT SHIFT
	DB	-1,-1	;43 \
	DB	0FAH,0FAH	;44 Z
	DB	0F8H,0F8H	;45 X
	DB	0E3H,0E3H	;46 C
	DB	0F6H,0F6H	;47 V
	DB	0E2H,0E2H	;48 B
	DB	0EEH,0EEH	;49 N
	DB	0EDH,0EDH	;50 M

Table2:
; This table is for char processing of chars < scancode 93.
	DB	0B1H	;59 F1  CODE 1
	DB	0B2H	;60 F2  CODE 2
	DB	0B3H	;61 F3  CODE 3
	DB	0B4H	;62 F4  CODE 4
	DB	0B5H	;63 F5  CODE 5
	DB	0B6H	;64 F6  CODE 6
	DB	0B7H	;65 F7  CODE 7
	DB	0B8H	;66 F8  CODE 8	
	DB	0B9H	;67 F9  CODE 9
	DB	0B0H	;68 F10 CODE 0
	DB	-1	;69
	DB	-1	;70
	DB	0D4h	;71 home  Code-Left
	DB	0C5h	;72 up
	DB	0D3h	;73 PgUp  Code-Up
	DB	-1	;74 -
	DB	0C6h	;75 left
	DB	08Dh	;76 5
	DB	0C7h	;77 right
	DB	8Dh	;78 +  Confirm
	DB	0D5h	;79 End   Code-Right	
	DB	0C4h	;80 down
	DB	0D2h	;81 PgDn  Code-Down
	DB	0E9h	;82 INS
	DB	088h	;83 DEL
	DB	0A1H	;84 Shift F1  CODE SHIFT 1
	DB	0C0H	;85 Shift F2  CODE SHIFT 2
	DB	0A3H	;86 Shift F3  CODE SHIFT 3
	DB	0A4H	;87 Shift F4  CODE SHIFT 4
	DB	0A5H	;88 Shift F5  CODE SHIFT 5
	DB	0DEH	;89 Shift F6  CODE SHIFT 6
	DB	0A6H	;90 Shift F7  CODE SHIFT 7
	DB	0AAH	;91 Shift F8  CODE SHIFT 8
	DB	0A8H	;92 Shift F9  CODE SHIFT 9
	DB	0A9H	;93 Shift F10 CODE SHIFT 0


Table3:
; This table is for char and shift char processing of chars < scancode 132.
	DB	0B1H,0A1h	;104 ALT F1  CODE 1
	DB	0B2H,0C0h	;105 ALT F2  CODE 2
	DB	0B3H,0A3h	;106 ALT F3  CODE 3
	DB	0B4H,0A4h	;107 ALT F4  CODE 4
	DB	0B5H,0A5h	;108 ALT F5  CODE 5
	DB	0B6H,0DEh	;109 ALT F6  CODE 6
	DB	0B7H,0A6h	;110 ALT F7  CODE 7
	DB	0B8H,0AAh	;111 ALT F8  CODE 8	
	DB	0B9H,0A8h	;112 ALT F9  CODE 9
	DB	0B0H,0A9h	;113 ALT F10 CODE 0
	DB	-1,-1	;114
	DB	86h,90h	;115 Ctrl Left
	DB	87h,91h	;116 Ctrl Right
	DB	95h,99h	;117 Ctrl End
	DB	92h,96h	;118 Ctrl PgDn
	DB	94h,98h	;119 Ctrl Home
	DB	0B1H,0A1H	;120 1
	DB	0B2H,0C0H	;121 2
	DB	0B3H,0A3H	;122 3
	DB	0B4H,0A4H	;123 4
	DB	0B5H,0A5H	;124 5
	DB	0B6H,0DEH	;125 6
	DB	0B7H,0A6H	;126 7
	DB	0B8H,0AAH	;127 8
	DB	0B9H,0A8H	;128 9
	DB	0B0H,0A9H	;129 0
	DB	0ADH,7FH	;130 -
	DB	0BDH,0ABH	;131 =
	DB	93h,97h	;132 Ctrl PgUp


SpecialCases:	; Scancode special cases
	DB	14	; Backspace
	DB	28	; Cr 
	DB	15	; tab
	DB	1	; Esc
	DB	53	; /
	DB	39	; ;
	DB	40	; quote
	DB	51	; ,
	DB	52	; .
ScanLenWithoutNumLock  EQU $ - SpecialCases

	DB	80	; Down
	DB	75	; left
	DB	77	; right
	DB	72	; up 
	DB	71	; Home IBM PC keybaords
	DB	79	; End IBM PC Keyboards
	DB	71	; Home GRiDCase Keyboards
	DB	79	; End GRiDCase Keyboards
	DB	76	; 5 IBM PC Keyboards
	DB	76	; 5 GRiDCase Keyboards
	DB	84	; Sys Req IBM AT Keyboards
	DB	73	; PgUp
	DB	81	; PgDn
	DB	78	; + IBM PC
	DB	78	; + GRiDCase
	DB	82	; INS IBM PC
	DB	82	; INS GRiDCase
	DB	83	; DEL IBM PC
	DB	83	; DEL GRiDCase
	DB	55	; * IBM PC
	DB	55	; * GRiDCase
ScanLen EQU  $ - SpecialCases

SpecialTable:
	DB	08H,0C8H,88H,8AH	;14 <--
	DB	0Dh,0CDh,8Dh,8CH	;28 Cr
	DB	09H,0C9H,89H,8BH	;15 -->|
	DB	1BH,1BH,9BH,9BH	;1  ESC
	DB	02Fh,03Fh,0BFh,0BFh	;53 /
	DB	03Bh,03Ah,05Ch,07Ch	;39 ;
	DB	027h,022h,060h,07Eh	;40 quote
	DB	02Ch,03Ch,05Bh,07Bh	;51 ,
	DB	02Eh,03Eh,05DH,07Dh	;52 .

; If not in NUMLOCK mode, these keys will be checked also.
	DB	0C4h,0CEh,0D2h,0D6h	;80 down
	DB	0C6h,0D0h,0D4h,0D8h	;75 left
	DB	0C7h,0D1h,0D5h,0D9h	;77 right
	DB	0C5h,0CFh,0D3h,0D7h	;72 up
	DB	0D7h,0D7h,0D7h,0D7h	;71 Home IBM PC  Index 13 (These keys have CODE)
	DB	0D6h,0D6h,0D6h,0D6h	;79 End IBM Pc   Index 14 (and shift bits set)
	DB	0D4h,0D8h,0D4h,0D8h	;71 Home GRiDCase (These keys will have the)
	DB	0D5h,0D9h,0D5h,0D9h	;79 End GRiDCase  (CODE bit set only)
	DB	-1,-1,-1,-1	;76 5 IBM PC
	DB	8Dh,8Ch,8Dh,8Ch	;76 5 GRiDCase
	DB	8Dh,8Ch,8Dh,8Ch	;84 Sys Req IBM AT
	DB	0D3h,0D7h,0D3h,0D7h	;73 PgUp
	DB	0D2h,0D6h,0D2h,0D6h	;81 PgDn
	DB	08Dh,08Ch,08Dh,08Ch	;78 + IBM PC
	DB	-1,-1,-1,-1	;78 + GRiDCase
	DB	0E9h,0E9h,-1,-1	;82 Ins IBM PC
	DB	0E9h,0E9h,0BAh,0BAh	;82 Ins GRiDCase
	DB	088h,088h,-1,-1	;83 Del IBM PC
	DB	088h,088h,0BBh, 0BBh	;83 Del GRiDCase Index 27
	DB	0CFh,0CFh,0CFh,0CFh	;55 *   IBM PC   (all keys below 27 will have)
	DB	-1,-1,-1,-1	;55 *   GRiDCase (the shift bit set only)
			;(Beware when new keys are added)
; ClearTheBuffer
;
; This routine will clear the buffer in the bios

ClearTheBuffer PROC NEAR

ClearTheBuffer10:
	MOV	AH, 1	; check keyboard status
	INT	16h
	JZ	BufferEmpty	; are there any keys?
	MOV	AH, 0
	INT	16h
	JMP	SHORT ClearTheBuffer10
BufferEmpty:
	RET
ClearTheBuffer ENDP



;
;	GetKeyFromDOS: PROCEDURE WORD;
;
GetKeyFromDOS PROC FAR
	PUSH	DS
	MOV	DS, CS:DataFrame

	MOV	AL, Last_Scan_Code	; get the last scan code
	CMP	AL, CODE_KEY + Break	; case of alt with numeric - clear it
	JNE	CheckSpecialCases
	CALL	ClearTheBuffer
	JMP	ReturnWithNothing

CheckSpecialCases:
	PUSH	AX
	MOV	AH, 2
	INT	16h	; Determine if we are in NumLock state 
	TEST	AL, NumLockState
	JZ	NotNumLock
	MOV	CX, scanLenWithoutNumLock ;Length of special case
	JMP	SHORT DoSpecialCase

NotNumLock:
	MOV	CX, ScanLen	; GET LENGTH

DoSpecialCase:
	MOV	DI, OFFSET SpecialCases	; GET SHIFT KEY TABLE
;	MOV	AX, SYSDEP_DGROUP
;	MOV	ES, AX
;	CMP	ES:systemType, hornet	; are we running on a GRiDCase?
	TEST	DS:gridMachine, 1	; are we running on a GRiD machine ?
	JNZ	GotHornet
	CLD		; compare in forward direction
	MOV	BX, NULLWORD	; fudge factor for after scasb
	JMP	SHORT DoSpecialCase10

GotHornet:
	STD		; for GRiDCase compare backwards
	MOV	BX, 1	; fudge factor for after scasb
	ADD	DI, CX	; this allows for different PC and
	DEC	DI	; GRiDCase entries

DoSpecialCase10:
	POP	AX
	PUSH	CS
	POP	ES	; Setup segment register
	REPNE SCASB	; LOOK FOR MATCH of special case scan codes
	JNE	CheckBIOS	; NOT a special case
			; Special case scancode found.
	CALL	ClearTheBuffer

	SUB	DI, OFFSET SpecialCases
	ADD	DI, BX	; SCASB puts me off by 1, -1

; Now see if we have to set the shift and/or code bits for this key

	CMP	DI, 13	; Is this key in the "special" range
	JB	DoSpecialCase20
	CMP	DI, 27	; check the high end
	JA	DoSpecialCase30

	OR	key_Mask, CodeBit	; OR in the code bit

	CMP	DI, 14
	JA	DoSpecialCase20

DoSpecialCase30:
	OR	key_Mask, Shift	; OR in the shift bit

DoSpecialCase20:
	SHL	DI, 1
	SHL	DI, 1	; point to the right entry
	TEST key_Flags, Shift
	JZ	SpecialNOShift
	INC	DI

SpecialNoShift:
	TEST key_Flags, CodeBit
	JZ	SpecialNoCode
	ADD	DI, 2

SpecialNoCode:
	ADD	DI, OFFSET SpecialTable
	MOV	AL, BYTE PTR CS:[DI]
	CMP	AL, -1
	JE	ReturnWithNothing
	JMP	ProcessCtrl

CheckBIOS:
	MOV	AH, 1	; check keyboard status
	INT	16h
	JZ	ReturnWithNothing	; are there any keys?
	MOV	AH, 0
	INT	16h
	CMP	AL, 0	; is this character extended?
	JNE	ReturnTheChar
; extended character processing...
	MOV	AL, AH
	XOR	AH, AH
	MOV	BX, AX

	CMP	AL, 32h	; do we fit in table 1?
	JA	TryTable2

; get the char
	SUB	BX, 16
	SHL	BX, 1	; 2 entries per line
	TEST key_Flags, Shift
	JZ	Table1NOShift
	INC	BX	; over 1 for shift

Table1NoShift:
	MOV	SI, OFFSET Table1
	MOV	AL, BYTE PTR CS:[BX][SI]
	JMP	ProcessCtrl

TryTable2:
	CMP	AL, 93
	JA	TryTable3

	SUB	BX, 59
	MOV	SI, OFFSET Table2
	MOV	AL, BYTE PTR CS:[BX][SI]
	JMP	ReturnTheChar	; Cntl mods will generate different scancodes

TryTable3:
	CMP	AL, 103	; If not Cntl-Fn keys
	JA	InTable3Range	; then index into table

	ADD	BX, 10	; else make cntl-fns look like alt-fns
			; and 'cntl'ize them below in ProcessCtrl
InTable3Range:
	SUB	BX, 104
	SHL	BX, 1	; 2 entries per line
	TEST key_Flags, Shift
	JZ	Table3NOShift
	INC	BX

Table3NoShift:
	MOV	SI, OFFSET Table3
	MOV	AL, BYTE PTR CS:[BX][SI]

ProcessCtrl:
	TEST key_Flags, Ctl
	JZ	ReturnTheChar

	AND	AL, Ctl_Mask
	JMP	SHORT ReturnTheChar


ReturnWithNothing:
	MOV	AX, NULLWORD
	JMP	Short ExitGetKey

ReturnTheChar:
	CMP	AL, -1
	JE	ReturnWithNothing
	MOV	AH, key_Mask

;Set Status Byte (Function Key bit)

;set the FnKey bit
	MOV	BH, Last_Scan_Code
	CMP	BH, 59	; is it < F1
	JL	WriteOutKey	; NO, Write Out the key
	CMP	BH, 68	; is it <= F10
	JLE	Set_FKey	; YES, Set Fkey
	CMP	BH, 82	; Is it Ins?
	JE	Set_FKey	; Yes, set FKey
	CMP	BH, 83	; Is it Del?
	JNE	WriteOutKey	; No, Write Out Key

Set_FKey:
	OR	AH,FKey	; set FKey bit

WriteOutKey:
	MOV	DS:KeyboardStatusKey, AX
	CALL	DWORD PTR DS:KeyHandlerOff	; put it in our type ahead buffer

ExitGetKey:
	POP	DS
	RET
GetKeyFromDOS ENDP

  CODE ENDS

  END
